/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.event.Server;

import com.marth7th.solidarytinker.client.Renderer.Halo.HaloRegistry;
import com.marth7th.solidarytinker.client.Renderer.Halo.HaloRendererUtil;
import com.marth7th.solidarytinker.shelf.Network.Packet.HaloUpdatePacket;
import com.marth7th.solidarytinker.shelf.Network.STChannel;
import com.marth7th.solidarytinker.util.method.ModifierLevel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierId;

@Mod.EventBusSubscriber(modid="solidarytinker")
public class HaloUpdateOnServer {
    private static final Map<UUID, Map<ModifierId, Boolean>> SERVER_PLAYER_HALO_CACHE = new ConcurrentHashMap<UUID, Map<ModifierId, Boolean>>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            Player player = event.player;
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_19797_ % 20 == 0) {
                ConcurrentHashMap<ModifierId, Boolean> haloStatesToSync = new ConcurrentHashMap<ModifierId, Boolean>();
                Map playerCache = SERVER_PLAYER_HALO_CACHE.computeIfAbsent(serverPlayer.m_20148_(), k -> new ConcurrentHashMap());
                for (HaloRendererUtil halo : HaloRegistry.getAllHalos()) {
                    boolean previousHaloState;
                    boolean currentHaloState = ModifierLevel.getAllSlotModifierlevel((LivingEntity)serverPlayer, halo.getModifierId()) > 0;
                    if (currentHaloState == (previousHaloState = playerCache.getOrDefault(halo.getModifierId(), false).booleanValue())) continue;
                    playerCache.put(halo.getModifierId(), currentHaloState);
                    haloStatesToSync.put(halo.getModifierId(), currentHaloState);
                }
                if (!haloStatesToSync.isEmpty()) {
                    STChannel.sendToTrackingAndSelf(new HaloUpdatePacket(serverPlayer.m_20148_(), haloStatesToSync), serverPlayer);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        SERVER_PLAYER_HALO_CACHE.remove(event.getEntity().m_20148_());
    }
}

